<?php include_once(__ROOT__ . '/admin/partials/_header.php'); ?>

<div class="page-header">
    <h1 class="page-header-title">Edit Gateway: <?php echo htmlspecialchars($gateway['name']); ?></h1>
</div>

<form method="POST">
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">Gateway Settings</h4>
        </div>
        <div class="card-body">
            <?php
            // Load the settings UI from the plugin folder
            $settings_file = __ROOT__ . '/content/plugins/gateways/' . $gateway['slug'] . '/settings.php';
            if (file_exists($settings_file)) {
                include $settings_file;
            } else {
                echo '<div class="alert alert-danger">Settings file not found for this gateway.</div>';
            }
            ?>
        </div>
        <div class="card-footer text-end">
            <a href="<?php echo APP_URL; ?>/admin/gateways" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Save Settings</button>
        </div>
    </div>
</form>

<?php include_once(__ROOT__ . '/admin/partials/_footer.php'); ?>
